/**
 * BotFake Recorder - Content Script
 * Handles communication between page and extension
 */

// Listen for messages from popup
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  switch (message.type) {
    case 'START_RECORDING':
      injectRecorder();
      sendResponse({ success: true });
      break;
      
    case 'STOP_RECORDING':
      if (window.__BOTFAKE_RECORDER__) {
        window.__BOTFAKE_RECORDER__.stop();
      }
      sendResponse({ success: true });
      break;
      
    case 'DOWNLOAD_SCENARIO':
      if (window.__BOTFAKE_RECORDER__) {
        window.__BOTFAKE_RECORDER__.download();
      }
      sendResponse({ success: true });
      break;
      
    case 'GET_SCENARIO':
      if (window.__BOTFAKE_RECORDER__) {
        sendResponse({ scenario: window.__BOTFAKE_RECORDER__.generateScenario() });
      } else {
        sendResponse({ scenario: null });
      }
      break;
  }
  
  return true; // Keep channel open for async response
});

function injectRecorder() {
  // Check if already injected
  if (window.__BOTFAKE_RECORDER__) {
    window.__BOTFAKE_RECORDER__.start();
    return;
  }
  
  // Inject the recorder script
  const script = document.createElement('script');
  script.src = chrome.runtime.getURL('recorder.js');
  script.onload = () => {
    script.remove();
    // Start recording after injection
    setTimeout(() => {
      if (window.__BOTFAKE_RECORDER__) {
        window.__BOTFAKE_RECORDER__.start();
      }
    }, 100);
  };
  (document.head || document.documentElement).appendChild(script);
}

// Listen for updates from recorder and forward to popup
window.addEventListener('message', (event) => {
  if (event.data && event.data.type === 'BOTFAKE_RECORDER_UPDATE') {
    chrome.runtime.sendMessage({
      type: 'RECORDING_UPDATE',
      actionsCount: event.data.actionsCount
    });
  }
});

